/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.ntfy;

import com.ibm.hwmca.base.ntfy.NotificationConstants;
import com.ibm.hwmca.base.ntfy.NotificationMessageRes;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TaskMessage;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class MessageFilterEditorPanelBean
extends PanelBean
implements NotificationConstants {
    private static final String TRACE_MASKT = "XNTYMFPT";
    private static final String TRACE_MASKF = "XNTYMFPF";
    private static final String TRACE_MASKD = "XNTYMFPD";
    private String m_sName;
    private String m_sDescriptionInput;
    private String m_sMsgTemplate;
    private transient ItemDescriptor[] m_idMsgFilterTable;
    private transient ColumnDescriptor[] m_cdMsgFilterTableStructure;
    private int[] m_iMsgFilterTableSelection;
    private Map data;
    public static final String DATA_MAP_NAME = "DataMapName";
    public static final String DATA_MAP_DESC = "DataMapDesc";
    public static final String DATA_MAP_TEMPLATE = "DataMapTemplate";
    public static final String DATA_MAP_FILTER_TABLE = "DataMapFilterTable";
    public static final String MSG_TEMPLATE = "MsgTemplate";
    public static final String MSG_FILTER_TABLE = "MsgFilterTable";
    private int numRows = 0;
    public static final String OP_EQUALS = "MessageFilterEditorPanel.OpEquals.VALUE";
    public static final String OP_NOT_EQUALS = "MessageFilterEditorPanel.OpNotEquals.VALUE";
    public static final String OP_AFTER = "MessageFilterEditorPanel.OpAfter.VALUE";
    public static final String OP_BEFORE = "MessageFilterEditorPanel.OpBefore.VALUE";
    public static final String OP_DONT_CARE = "MessageFilterEditorPanel.OpDontCare.VALUE";
    public static final String OP_BETWEEN = "MessageFilterEditorPanel.OpBetween.VALUE";
    public static final String OP_NOT_BETWEEN = "MessageFilterEditorPanel.OpNotBetween.VALUE";
    public static final String OP_IN = "MessageFilterEditorPanel.OpIn.VALUE";
    public static final String OP_NOT_IN = "MessageFilterEditorPanel.OpNotIn.VALUE";
    public static final String OP_GREATER_THAN = "MessageFilterEditorPanel.OpGreaterThan.VALUE";
    public static final String OP_LESS_THAN = "MessageFilterEditorPanel.OpLessThan.VALUE";
    public static final String OP_GREATER_THAN_OR_EQUAL = "MessageFilterEditorPanel.OpGreaterThanOrEqual.VALUE";
    public static final String OP_LESS_THAN_OR_EQUAL = "MessageFilterEditorPanel.OpLessThanOrEqual.VALUE";
    public static final String OP_MATCHES = "MessageFilterEditorPanel.OpMatches.VALUE";
    private static final String RES_NAME = "com.ibm.hwmca.base.ntfy.res.NotificationRes";

    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACE_MASKT, "-> panelAction()");
        String command = event.getActionCommand();
        if (command == null || command.equals("CANCEL")) {
            command = this.getMountPrefix() + "CancelButton";
        }
        this.userTaskManager.storeAllElements();
        PanelTaskletRequest request = new PanelTaskletRequest(this.getClass().getName() + this.getMountPrefix());
        request.setData("CommandSource", "MessageFilterEditorPanel");
        if (command.equals(this.getMountPrefix() + "OKButton") || command.equals(this.getMountPrefix() + "ApplyButton")) {
            if (command.equals(this.getMountPrefix() + "OKButton")) {
                request.setData("CommandName", "OKButton");
            } else {
                request.setData("CommandName", "ApplyButton");
            }
            this.m_sMsgTemplate = this.userTaskManager.getValue(this.getMountPrefix() + MSG_TEMPLATE);
            this.m_sName = this.m_sName.trim();
            request.setData(DATA_MAP_NAME, this.m_sName);
            request.setData(DATA_MAP_DESC, this.m_sDescriptionInput);
            ResourceBundle res = ResourceBundle.getBundle(RES_NAME);
            String[][] table = new String[this.numRows][3];
            int i = 0;
            while (i < this.numRows) {
                ItemDescriptor[] row = this.userTaskManager.getRow(this.getMountPrefix() + MSG_FILTER_TABLE, i);
                table[i][0] = row[0].getTitle();
                String op = row[1].getTitle();
                if (op.equals(res.getString(OP_DONT_CARE))) {
                    table[i][1] = OP_DONT_CARE;
                } else if (op.equals(res.getString(OP_EQUALS))) {
                    table[i][1] = OP_EQUALS;
                } else if (op.equals(res.getString(OP_NOT_EQUALS))) {
                    table[i][1] = OP_NOT_EQUALS;
                } else if (op.equals(res.getString(OP_AFTER))) {
                    table[i][1] = OP_AFTER;
                } else if (op.equals(res.getString(OP_BEFORE))) {
                    table[i][1] = OP_BEFORE;
                } else if (op.equals(res.getString(OP_BETWEEN))) {
                    table[i][1] = OP_BETWEEN;
                } else if (op.equals(res.getString(OP_NOT_BETWEEN))) {
                    table[i][1] = OP_NOT_BETWEEN;
                } else if (op.equals(res.getString(OP_IN))) {
                    table[i][1] = OP_IN;
                } else if (op.equals(res.getString(OP_NOT_IN))) {
                    table[i][1] = OP_NOT_IN;
                } else if (op.equals(res.getString(OP_GREATER_THAN))) {
                    table[i][1] = OP_GREATER_THAN;
                } else if (op.equals(res.getString(OP_LESS_THAN))) {
                    table[i][1] = OP_LESS_THAN;
                } else if (op.equals(res.getString(OP_GREATER_THAN_OR_EQUAL))) {
                    table[i][1] = OP_GREATER_THAN_OR_EQUAL;
                } else if (op.equals(res.getString(OP_LESS_THAN_OR_EQUAL))) {
                    table[i][1] = OP_LESS_THAN_OR_EQUAL;
                } else if (op.equals(res.getString(OP_MATCHES))) {
                    table[i][1] = OP_MATCHES;
                }
                table[i][2] = row[2].getTitle();
                try {
                    if (table[i][1] == OP_MATCHES && table[i][2] != null && !table[i][2].trim().equals("")) {
                        Pattern.compile(table[i][2]);
                    }
                }
                catch (PatternSyntaxException re) {
                    TaskMessage tm = new TaskMessage(this.userTaskManager, MessageFormat.format(new NotificationMessageRes().getString("ntfy.error.regexpproblem"), table[i][2], re.getMessage()), 1);
                    tm.invoke();
                    return;
                }
                ++i;
            }
            request.setData(MSG_FILTER_TABLE, table);
            request.setData(DATA_MAP_TEMPLATE, this.data.get(DATA_MAP_TEMPLATE));
        } else if (command.equals(this.getMountPrefix() + "CancelButton")) {
            request.setData("CommandName", "CancelButton");
        } else if (command.equals(this.getMountPrefix() + "TemplateButton")) {
            request.setData(DATA_MAP_TEMPLATE, this.data.get(DATA_MAP_TEMPLATE));
            request.setData("CommandName", "TemplateButton");
        }
        if ((request.getData("CommandName").equals("OKButton") || request.getData("CommandName").equals("ApplyButton")) && (this.m_sName == null || this.m_sName.trim().equals(""))) {
            TaskMessage tm = new TaskMessage(this.userTaskManager, new NotificationMessageRes().getString("ntfy.error.blankname"), 1);
            tm.invoke();
            this.userTaskManager.setValue(this.getMountPrefix() + "Name", "");
            this.m_sName = "";
        } else {
            this.postTaskletRequest(request);
        }
        Trace.trace(TRACE_MASKT, "<- panelAction()");
    }

    public void update(Object newData) {
        String command;
        Trace.trace(TRACE_MASKT, "-> update()");
        if (newData instanceof Map && (command = (String)((Map)newData).get("CommandName")).equals("TemplateButton")) {
            String newTemplate = (String)((Map)newData).get("TemplateButton");
            this.data.put(DATA_MAP_TEMPLATE, newTemplate);
            if (newTemplate != null && !newTemplate.trim().equals("") && !newTemplate.equals(this.m_sMsgTemplate)) {
                this.userTaskManager.setValue(this.getMountPrefix() + MSG_TEMPLATE, (String)((Map)newData).get("TemplateButton"));
                String[][] fields = (String[][])((Map)newData).get(DATA_MAP_FILTER_TABLE);
                try {
                    while (this.numRows > 0) {
                        this.userTaskManager.removeRow(this.getMountPrefix() + MSG_FILTER_TABLE, --this.numRows);
                    }
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    this.numRows = 0;
                }
                if (fields != null) {
                    ResourceBundle res = ResourceBundle.getBundle(RES_NAME);
                    String dontCare = res.getString(OP_DONT_CARE);
                    this.numRows = 0;
                    while (this.numRows < fields.length) {
                        ItemDescriptor id1 = new ItemDescriptor(this.getMountPrefix() + this.numRows + "_a", fields[this.numRows][0]);
                        ItemDescriptor id2 = new ItemDescriptor(this.getMountPrefix() + this.numRows + "_b", dontCare);
                        ItemDescriptor id3 = new ItemDescriptor(this.getMountPrefix() + this.numRows + "_c", "");
                        this.userTaskManager.addRow(this.getMountPrefix() + MSG_FILTER_TABLE, this.numRows, new ItemDescriptor[]{id1, id2, id3});
                        ++this.numRows;
                    }
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- update()");
    }

    public void verifyChanges() throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<> verifyChanges()");
    }

    public void save() {
        Trace.trace(TRACE_MASKT, "<> save()");
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "-> prepare()");
        this.userTaskManager.setReadOnly(this.getMountPrefix() + MSG_TEMPLATE, true);
        String[][] fields = (String[][])this.data.get(DATA_MAP_FILTER_TABLE);
        ResourceBundle res = ResourceBundle.getBundle(RES_NAME);
        if (fields != null) {
            this.numRows = 0;
            while (this.numRows < fields.length) {
                if (fields[this.numRows] != null && fields[this.numRows][0] != null && fields[this.numRows][1] != null) {
                    ItemDescriptor id1 = new ItemDescriptor(this.getMountPrefix() + this.numRows + "_a", fields[this.numRows][0]);
                    ItemDescriptor id2 = new ItemDescriptor(this.getMountPrefix() + this.numRows + "_b", res.getString(fields[this.numRows][1]));
                    ItemDescriptor id3 = new ItemDescriptor(this.getMountPrefix() + this.numRows + "_c", fields[this.numRows][2]);
                    this.userTaskManager.addRow(this.getMountPrefix() + MSG_FILTER_TABLE, this.numRows, new ItemDescriptor[]{id1, id2, id3});
                }
                ++this.numRows;
            }
        }
        Trace.trace(TRACE_MASKT, "<- prepare()");
    }

    public void load() {
        if (this.data == null) {
            this.data = new HashMap();
        }
        this.m_sName = (String)this.data.get(DATA_MAP_NAME);
        this.m_sDescriptionInput = (String)this.data.get(DATA_MAP_DESC);
        this.m_sMsgTemplate = (String)this.data.get(DATA_MAP_TEMPLATE);
        this.m_idMsgFilterTable = new ItemDescriptor[0];
        this.m_cdMsgFilterTableStructure = new ColumnDescriptor[0];
        this.m_iMsgFilterTableSelection = new int[0];
        if (this.m_sName == null) {
            this.m_sName = "";
        }
        if (this.m_sDescriptionInput == null) {
            this.m_sDescriptionInput = "";
        }
        if (this.m_sMsgTemplate == null) {
            this.m_sMsgTemplate = "";
        }
    }

    public void setData(Map data) {
        this.data = data;
    }

    public String getName() {
        return this.m_sName;
    }

    public void setName(String s) throws IllegalUserDataException {
        this.m_sName = s;
    }

    public String getDescriptionInput() {
        return this.m_sDescriptionInput;
    }

    public void setDescriptionInput(String s) throws IllegalUserDataException {
        this.m_sDescriptionInput = s;
    }

    public String getMsgTemplate() {
        return this.m_sMsgTemplate;
    }

    public void setMsgTemplate(String s) throws IllegalUserDataException {
        this.m_sMsgTemplate = s;
    }

    public ColumnDescriptor[] getMsgFilterTableRowStructure() {
        return this.m_cdMsgFilterTableStructure;
    }

    public int getMsgFilterTableRowStatus() {
        return 3;
    }

    public int getMsgFilterTableRowCount() {
        return 0;
    }

    public ItemDescriptor[] getMsgFilterTableRowAt(int index) {
        return this.m_idMsgFilterTable;
    }

    public void setMsgFilterTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idMsgFilterTable = items;
    }

    public int[] getMsgFilterTableSelection() {
        return this.m_iMsgFilterTableSelection;
    }

    public void setMsgFilterTableSelection(int[] selected) throws IllegalUserDataException {
        this.m_iMsgFilterTableSelection = selected;
    }
}

